package ihm;
import java.awt.Dimension;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GMenu;
import fr.cnes.genius.highLevel.GMenuBar;
import fr.cnes.genius.highLevel.GMenuItem;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GIcon;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GClear;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.threads.GCommandLauncher.GExecButton;
import fr.cnes.genius.threads.GCommandLauncher.GExecMenuItem;
import fr.cnes.genius.threads.GCommandLauncher.ProcessStatus;
import fr.cnes.genius.threads.GJavaCommandLauncher;

/**
 * Exercise #6 + clear + menu bar
 * @author goesterjf
 *
 */
public class GEx62Panel extends GPanel implements GListener, GReadWrite, GClear {
	
	private GMenuBar menuBar;
	private GMenu menuFile;
	private GMenuItem itemLoad;
	private GMenuItem itemSave;
	private GMenuItem itemClear;
	private GExecMenuItem itemExec;
	private GMenuItem itemQuit;

	private GButton butLoad;
	private GButton butSave;
	private GButton butQuit;
	private GButton butClear;

	private GScenario sceIhm;
	
	private GJavaCommandLauncher cmd;
	private GExecButton butExec;
	
	private final int sizeIcons = 24;
	
	/**
	 * Constructor.
	 * @throws GIntervalException
	 */
	public GEx62Panel() throws GIntervalException {
		
		String path = System.getProperty("java.class.path");
		cmd = new GJavaCommandLauncher(new String[] {"ihm.Batch", "datatmp.xml"}, path, "Launch computation", "Stop computation", null);
		cmd.setButtonIcons(new GIcon(GIcon.Type.START, sizeIcons), new GIcon(GIcon.Type.STOP, sizeIcons));
		// To assign the process output towards the standard output
		cmd.setCopyOutputToStdout(true);
		butExec= cmd.getGExecButton();
		butExec.setConstraint(null);
		
		itemLoad = new GMenuItem("Load");
		itemSave = new GMenuItem("Save");
		itemClear = new GMenuItem("Clear");
		itemExec = cmd.getGExecMenuItem();
		itemQuit = new GMenuItem("Quit");
		
		menuFile = new GMenu("File");
		menuFile.add(itemLoad);
		menuFile.add(itemSave);
		menuFile.add(itemClear);
		menuFile.add(itemExec);
		menuFile.add(itemQuit);

		menuBar = new GMenuBar(this);
		menuBar.add(menuFile);
		
		butLoad = new GButton("Load");
		butLoad.setConstraint(new GConstraint(GConstraint.split(3)));
		butLoad.setIcon(new GIcon(GIcon.Type.OPEN, sizeIcons));
		
		butSave = new GButton("Save");
		butSave.setIcon(new GIcon(GIcon.Type.SAVE, sizeIcons));
		butSave.setConstraint(null);
		
		butClear = new GButton("Clear");
		butClear.setIcon(new GIcon(GIcon.Type.CLEAR, sizeIcons));
		butClear.setConstraint(null);

		butQuit = new GButton("Quit");
		butQuit.setIcon(new GIcon(GIcon.Type.EXIT, sizeIcons));
		butQuit.setConstraint(new GConstraint(GConstraint.skip(1), GConstraint.alignx(XAlign.Right), GConstraint.growx()));
		
		sceIhm = new GScenario();
		sceIhm.setConstraint(new GConstraint(GConstraint.newline(true, 20), GConstraint.spanx(99), GConstraint.grow(), GConstraint.push()));
		
	}

	/**
	 * Before method override.
	 */
	public void before(GEvent e) throws GFileManipulatorException {
		
		if ( e.contains(butExec, itemExec) ) {
			if ( (! cmd.isRunning()) ) {
				if ( sceIhm.getScenario().size() > 0 ) {
					System.out.println("Writing data ...");
					GFileManipulation.writeConfig("dataTmp.xml", "Data", sceIhm, false);
					System.out.println("Computation started ...");
				}
				else {
					System.out.println("Computation cancelled ...");
					cmd.setInhibited(true);
				}
			}
		}
		
	}

	/**
	 * After method override.
	 */
	public void after(GEvent e) throws GException {
		
		if ( e.contains(butQuit) || e.contains(itemQuit) )	{ System.exit(0); }
		
		if ( e.contains(butClear) || e.contains(itemClear))	{ sceIhm.mainClear(); }
		
		if ( e.contains(butLoad) || e.contains(itemLoad))	{ GFileManipulation.readConfig("data.xml", "Data", sceIhm, false); }
		
		if ( e.contains(butSave) || e.contains(itemSave)) { GFileManipulation.writeConfig("data.xml", "Data", sceIhm, true); }
		
		if ( e.getFinalSource() == cmd )	{
			// Application has been launched
			if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_NORMALY ) {
				System.out.println("Computation nominally stopped ...");
			}
			else if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_BY_USER ) {
				System.out.println("Computation stopped by user ...");
			}
		}

	}

	/**
	 * Generic method override.
	 */
	public void generic() throws GException {
		put(cmd);
		put(butLoad);
		put(butSave);
		put(butClear);
		put(butExec);
		put(butQuit);
		put(sceIhm);		
	}

	/**
	 * Display method : only use generic one.
	 */
	public void display() throws GException { generic(); }

	/**
	 * Read method : only use generic one.
	 */
	public void read() throws GException { generic(); }

	/**
	 * Write method : only use generic one.
	 */
	public void write() throws GException { generic(); }
	
	/**
	 * Clear method : only use generic one.
	 */
	public void clear() throws GException { generic(); }
	
	public GMenuBar getMenuBar() {
		return menuBar;
	}
	
	/**
	 * @param args	no args ...
	 * @throws GIntervalException
	 */
	public static void main(String[] args) throws GIntervalException {

		GEx62Panel pan = new GEx62Panel();
		
		GFrame frame = new GFrame("GEx6", pan, pan.getMenuBar());
		frame.setMinimumSize(new Dimension(600, 500));
		
		frame.display();

	}

}
