package ihm;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import calc.Compute;
import calc.Maneuver;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GComponentList;
import fr.cnes.genius.main.GEnvironment;
import fr.cnes.genius.main.GFileManipulation;

/**
 * Batch mode to be called by GJavaCommandLauncher
 * @author goesterjf
 *
 */
public class Batch63 {

	/**
	 * Main method
	 * @param args	eventually the name of the XML data file
	 * @throws InterruptedException
	 * @throws GIntervalException
	 */
	public static void main(String[] args) throws InterruptedException, UnsupportedEncodingException {
		
		// UTF 8 mode
		GEnvironment.setOutputEncoding("UTF-8");
		
		String nameFile = "data63.xml"; // By default name of the data file
		if ( args.length > 0 ) {
			// We take the file name from the argument
			nameFile = args[0];
			}
		
		// Loading ...
		GComponentList sceList = new GComponentList("scenario", GManeuver.class, false);
		try {
			GFileManipulation.readConfig(nameFile, "Data", sceList, false);
		} catch (GFileManipulatorException e) {
			e.printStackTrace();
		}
		
		// We recover the scenario from the widget GComponentList ...
		ArrayList<GManeuver> list = sceList.getList();

		// We convert in Manoeuvre list ... and execute the computation
		ArrayList<Maneuver> scenario = new ArrayList<>();
		for ( GManeuver gman : list ) {
			scenario.add(gman.getManeuver());
		}
		Compute cmp = new Compute(scenario);
		cmp.run();

	}

}
