package ihm;

import calc.Compute;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.main.GFileManipulation;

/**
 * Batch mode to be called by GJavaCommandLauncher
 * @author goesterjf
 *
 */
public class Batch {

	/**
	 * Main method
	 * @param args	eventually the name of the XML data file
	 * @throws InterruptedException
	 * @throws GIntervalException
	 */
	public static void main(String[] args) throws InterruptedException, GIntervalException {
		
		String nameFile = "data.xml"; // By default name of the data file
		if ( args.length > 0 ) {
			// We take the file name from the argument
			nameFile = args[0];
			}
		
		// Loading ...
		GScenario sceIhm = new GScenario();
		try {
			GFileManipulation.readConfig(nameFile, "Data", sceIhm, false);
		} catch (GFileManipulatorException e) {
			e.printStackTrace();
		}
		
		// We recover the scenario from the widget ... and execute the computation
		Compute cmp = new Compute(sceIhm.getScenario());
		cmp.run();
		
	}

}
