package calc;

import java.util.ArrayList;

/**
 * Class defining the computation to do
 * @author goesterjf
 *
 */
public class Compute {
	
	/** List of maneuvers */
	private ArrayList<Maneuver> list;
	
	/**
	 * Constructor
	 * @param list	list of maneuvers
	 */
	public Compute ( ArrayList<Maneuver> list ) {
		
		this.list = list;
		
	}
	
	/**
	 * Method that will execute the computation (loop on maneuvers + display + sleep)
	 * @throws InterruptedException
	 */
	public void run () throws InterruptedException {
		
		if ( list.size() == 0 ) {
			System.out.println("No maneuvers ...");
		}
		else {
			for (int i = 0; i < list.size(); i++) {
				System.out.println("Maneuver "+(i+1));
				System.out.println("  Duration : "+(i+1)+" : "+list.get(i).getDuration()+" s");
				System.out.println("  Thrust   : "+(i+1)+" : "+list.get(i).getThrust()+" N");
				System.out.println("  Isp      : "+(i+1)+" : "+list.get(i).getIsp()+" s");
				Thread.sleep(1000);
			}			
		}
		
	}

}
