package calc;

/**
 * Class defining maneuver data
 * @author goesterjf
 *
 */
public class Maneuver {

	/** Duration of the maneuver */
	private double duration;
	/** Thrust level */
	private double thrust;
	/** Specific impulse */
	private double isp;
	
	/**
	 * Constructor
	 * @param duration Duration of the maneuver
	 * @param thrust   Thrust level
	 * @param isp      Specific impulse
	 */
	public Maneuver (double duration, double thrust, double isp) {
		this.duration = duration;
		this.thrust = thrust;
		this.isp = isp;
	}

	// Getters
	
	public double getDuration() {
		return duration;
	}

	public double getThrust() {
		return thrust;
	}

	public double getIsp() {
		return isp;
	}

}