package ihm;

import java.awt.Dimension;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Exercise #4
 * @author goesterjf
 *
 */
public class GEx4Panel extends GPanel implements GListener {
	
	private GButton but1;
	private GButton but2;
	private GButton but3;
	private GButton butQuit;

	private GScenario sceIhm;
	
	/**
	 * Constructor.
	 */
	public GEx4Panel() {
		
		but1 = new GButton("Button 1");
		but1.setConstraint(new GConstraint(GConstraint.split(3)));
		but2 = new GButton("Button 2");
		but2.setConstraint(null);
		but3 = new GButton("Button 3");
		but3.setConstraint(null);
		butQuit = new GButton("Quit");
		butQuit.setConstraint(new GConstraint(GConstraint.skip(1), GConstraint.alignx(XAlign.Right), GConstraint.growx()));

		sceIhm = new GScenario();
		sceIhm.setConstraint(new GConstraint(GConstraint.newline(true, 20), GConstraint.spanx(99), GConstraint.grow(), GConstraint.push()));
		
	}

	/**
	 * Generic method override.
	 */
	public void generic() throws GException {
		put(but1);
		put(but2);
		put(but3);
		put(butQuit);
		put(sceIhm);		
	}

	/**
	 * Display method : just call generic one.
	 */
	public void display() throws GException {
		generic();
	}

	/**
	 * Before method : nothing to do.
	 */
	public void before(GEvent e) { }

	/**
	 * After method override.
	 */
	public void after(GEvent e) {
		if ( e.contains(butQuit) )	{ System.exit(0); }
	}

	/**
	 * Main method
	 * @param args	no args ...
	 */
	public static void main(String[] args) {
		GEx4Panel pan = new GEx4Panel();
		GFrame frame = new GFrame("GEx4", pan);
		frame.setMinimumSize(new Dimension(600, 500));
		frame.display();
	}

}
