import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.constraints.GConstraint.Direction;
import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.constraints.GConstraint.YAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GSeparator;

/**
 * Exercise #2
 * @author goesterjf
 *
 */
public class GEx2 extends GPanel {
	
	private GLabel[] colTop;
	private int numColTop = 6;
	private GButton[] buts;
	private int numButMax = 34;
	
	private GSeparator sep;
	
	private GEntryReal[] reals;
	private int numReals = 3;
	
	private GEntryString string;
	
	/**
	 * Constructor
	 */
	public GEx2() {
		
		colTop = new GLabel[numColTop];
		for (int i = 0; i < numColTop; i++) {
			colTop[i] = new GLabel("Col "+(i+1));
			colTop[i].setConstraint(new GConstraint());
		}
		
		buts = new GButton[numButMax];
		
		int icell = 0;
		buts[icell] = new GButton("Button 0");
		
		buts[++icell] = new GButton("empty constraint");
		buts[icell].setConstraint(null);
		
		buts[++icell] = new GButton("skip 2");
		buts[icell].setConstraint(new GConstraint(GConstraint.skip(2)));
		
		buts[++icell] = new GButton("wrap 50");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap(true, 50)));

		buts[++icell] = new GButton("no constraint");
		buts[icell].setConstraint(new GConstraint());

		buts[++icell] = new GButton("newline");
		buts[icell].setConstraint(new GConstraint(GConstraint.newline()));

		buts[++icell] = new GButton("newline,span 2 .......................................................");
		buts[icell].setConstraint(new GConstraint(GConstraint.newline(), GConstraint.spanx(2)));
		
		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));

		buts[++icell] = new GButton("split 2");
		buts[icell].setConstraint(new GConstraint(GConstraint.split(2)));
		
		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));

		buts[++icell] = new GButton("split 2, flowy");
		buts[icell].setConstraint(new GConstraint(GConstraint.split(2), GConstraint.flow(Direction.Y)));

		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));

		buts[++icell] = new GButton("height 50");
		buts[icell].setConstraint(new GConstraint(GConstraint.height(50)));

		buts[++icell] = new GButton("width 50");
		buts[icell].setConstraint(new GConstraint(GConstraint.width(150)));

		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));

		buts[++icell] = new GButton("push");
		buts[icell].setConstraint(new GConstraint(GConstraint.push()));
		
		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));

		buts[++icell] = new GButton("growx");
		buts[icell].setConstraint(new GConstraint(GConstraint.growx()));
		
		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));

		buts[++icell] = new GButton("gapleft 20");
		buts[icell].setConstraint(new GConstraint(GConstraint.gapleft(20)));

		buts[++icell] = new GButton("gapright 50");
		buts[icell].setConstraint(new GConstraint(GConstraint.gapright(50)));
		
		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));
	
		buts[++icell] = new GButton("gaptop 50");
		buts[icell].setConstraint(new GConstraint(GConstraint.gaptop(50)));

		buts[++icell] = new GButton("gapbottom 20");
		buts[icell].setConstraint(new GConstraint(GConstraint.gapbottom(20)));
		
		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));
	
		buts[++icell] = new GButton("alignx left");
		buts[icell].setConstraint(new GConstraint(GConstraint.alignx(XAlign.Left)));

		buts[++icell] = new GButton("alignx center");
		buts[icell].setConstraint(new GConstraint(GConstraint.alignx(XAlign.Center)));

		buts[++icell] = new GButton("alignx right");
		buts[icell].setConstraint(new GConstraint(GConstraint.alignx(XAlign.Right)));

		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));
	
		buts[++icell] = new GButton("height 100");
		buts[icell].setConstraint(new GConstraint(GConstraint.height(100)));

		buts[++icell] = new GButton("aligny top");
		buts[icell].setConstraint(new GConstraint(GConstraint.aligny(YAlign.Top)));

		buts[++icell] = new GButton("aligny center");
		buts[icell].setConstraint(new GConstraint(GConstraint.aligny(YAlign.Center)));

		buts[++icell] = new GButton("aligny bottom");
		buts[icell].setConstraint(new GConstraint(GConstraint.aligny(YAlign.Bottom)));

		buts[++icell] = new GButton("wrap");
		buts[icell].setConstraint(new GConstraint(GConstraint.wrap()));
	
		sep = new GSeparator(GSeparator.HORIZONTAL);
		sep.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(20), GConstraint.growx(), GConstraint.spanx(99)));

		reals = new GEntryReal[numReals];

		reals[0] = new GEntryReal("'newline, split 2 | skip 1'", 11.);
		reals[0].setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.split(2)), 0);
		reals[0].setInnerDescendantConstraint(new GConstraint(GConstraint.skip(1)), 1);
		
		reals[1] = new GEntryReal("'? | skip 1, wrap'", 22.);
		reals[1].setInnerDescendantConstraint(new GConstraint(GConstraint.skip(1), GConstraint.wrap()), 1);
		
		reals[2] = new GEntryReal("'split 3 | '", 33.);
		reals[2].setInnerDescendantConstraint(new GConstraint(GConstraint.split(3)), 0, 0);
		
		string = new GEntryString("width 10", "y");
		string.setInnerDescendantConstraint(new GConstraint(GConstraint.width(10)), 1);
	}
	
	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }
	
	/**
	 * Display method override.
	 */
	public void display() throws GException {
		for (int i = 0; i < numColTop; i++) { put(colTop[i]); }		
		for (int i = 0; i < numButMax; i++) { put(buts[i]); }		
		put(sep);
		for (int i = 0; i < numReals; i++) {
			put(reals[i]);
		}
		put(string);
	}

	/**
	 * Main method
	 * @param args	no args ...
	 */
	public static void main(String[] args) {
		GEx2 pan = new GEx2();
		GFrame frame = new GFrame("GEx2", pan);
		frame.display();
	}

}
