package UncaughtExceptions;

import java.awt.Dimension;
import java.util.Date;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryDate;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEnvironment;

/**
 * Testing uncaught exceptions.
 * @author goesterjf
 *
 */
public class TestForUncaughtExceptions extends GPanel {
	
	private GEntryDate date;
	
	public TestForUncaughtExceptions () {
		
		date = new GEntryDate("My Date:", new Date());
	}

	@Override
	public void display() throws GException {
		generic();
	}

	@Override
	public void generic() throws GException {
		put(date);
	}

	public GEntryDate getDate() {
		return date;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {

        GEnvironment.setGUncaughtExceptionHandler(new UncaughtException());

        TestForUncaughtExceptions test = new TestForUncaughtExceptions();

		GFrame frame = new GFrame("TestForUncaughtExceptions", test);
		frame.getJFrame().setPreferredSize(new Dimension(300, 100));
		frame.display();

	}

}
