
import java.util.Locale;

import fr.cnes.genius.exception.GEnvironmentException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEnvironment;

/**
 * Testing internationalization.
 * @author goesterjf
 *
 */
public class TestForInternationalization extends GPanel {
	
	private GButton but;
	private GEntryString str;
	private GEntryInt ent;
	private GEntryReal val;
	private GCheckBox che;
	private GLabel lab;
	
	public TestForInternationalization() {
		but = new GButton(GEnvironment.tr("Button"));
		str = new GEntryString(GEnvironment.tr("Character string entry:"), "text");
		ent = new GEntryInt(GEnvironment.tr("Integer entry:"), 123);
		val = new GEntryReal(GEnvironment.tr("Real entry:"), 99.);
		che = new GCheckBox(GEnvironment.tr("Boolean"));
		che.setSelected(true);
		lab = new GLabel(GEnvironment.tr("This is a label ..."));
	}

	public void generic() { }

	public void display() throws GException {
		put(but);
		put(str);
		put(ent);
		put(val);
		put(che);
		put(lab);
	}
	
	/**
	 * @param args
	 * @throws GEnvironmentException 
	 */
	public static void main(String[] args) throws GEnvironmentException {
		
		GEnvironment.initI18n(new Locale("es"));
		TestForInternationalization pan = new TestForInternationalization();
		GFrame frame = new GFrame(GEnvironment.tr("Test For internationalization"), pan);	
		frame.display();
	}

	
}
