import java.awt.Dimension;

import fr.cnes.genius.exception.GEntryRealException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.table.GTable2D;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GTemperatureUnit;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.utils.GPanTest;

/**
 * Test for class GTable2D
 * @author goesterjf
 *
 */
public class TestForGTable2D extends GPanel implements GListener, GReadWrite {
	
	private GLabel label1;
	private GLabel label2;
	private GTable2D volTable;
	
	private final GUnit[] unitVolume = {new GMetricUnit("m^3"), new GMetricUnit("dm^3")};
	private final GUnit[] unitPressure = {new GMetricUnit("Pa"), new GMetricUnit("mPa")};
	private final GUnit[] unitTemperature = {new GTemperatureUnit("K"), new GTemperatureUnit("°C")};
	
	TestForGTable2D () throws GIntervalException, GEntryRealException {
		
		double[][] vol  = { {50. , 100.0, 150.0}, {60. , 110.0, 120.0}, {75. , 125.0, 175.0} };
		double[] pres   = {  1.,   10.0,  20.0 };
		double[] temp   = { 250.0, 300.0, 350.0 };
		
		volTable = new GTable2D ( pres, "Pressure", unitPressure, temp, "Temperature", unitTemperature, vol, "Volume", unitVolume);
		volTable.getGTable().setColumnHeaderFracDigits(12);
		volTable.getGTable().setRowHeaderFracDigits(14);
		volTable.getGTable().setNameInConfigFile("tab2");
		
		label1 = new GLabel("Beginning of GTable2D");
		label2 = new GLabel("End of GTable2D");
		label2.setConstraint(null);
		
	}

	public void display() throws GException { generic(); }

	public void generic() throws GException {
		put(volTable);
		put(label1);
		put(label2);
	}
	
	@Override
	public void read() throws GException { generic(); }

	@Override
	public void write() throws GException { generic(); }
	
	public void after(GEvent arg0) {

	}
	
	public void before(GEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public static void main(String[] args) throws GIntervalException, GEntryRealException {

		TestForGTable2D test = new TestForGTable2D();

		GPanTest panTest = new GPanTest("Test GTable2D", test,"GTable2D.xml");
		panTest.getJFrame().setPreferredSize(new Dimension(1000, 500));

		panTest.display();
		
	}

}
