import java.awt.Dimension;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GEntryRealVector;
import fr.cnes.genius.highLevel.GTable1D;
import fr.cnes.genius.highLevel.GTable1D.TableOrientation;
import fr.cnes.genius.interval.GInterval;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.utils.GPanTest;

/**
 * Test for class GTable
 * @author goesterjf
 *
 */
public class TestForGTable1D extends GPanel implements GListener {
	
	private GTable1D aeroTabIhm;
	
	private GEntryRealVector incTabIhm;
	private GEntryRealVector CxTabIhm;
	private GEntryRealVector CzTabIhm;
	
	private GButton butDisp;
	
	private final GUnit[] unitAng = {new GMetricUnit("deg"), new GMetricUnit("rad")};
	
	TestForGTable1D () throws GIntervalException {
		
		double[] incVal  = {Math.toRadians(10.),   Math.toRadians(15.),   Math.toRadians(20.),
				            Math.toRadians(25.),   Math.toRadians(30.),   Math.toRadians(35.),
				            Math.toRadians(40.)};
		double[] cxVal   = {0.100, 0.150, 0.200, 0.250, 0.350, 0.450, 0.600};
		double[] czVal   = {0.250, 0.300, 0.350, 0.400, 0.500, 0.550, 0.600};
		GInterval errInterval = new GInterval(0., 1.);
		
		incTabIhm = new GEntryRealVector("Angle Of Attack", incVal, unitAng);
		incTabIhm.setNameInConfigFile("AOA");
		CxTabIhm = new GEntryRealVector("Cx", cxVal);
		CzTabIhm = new GEntryRealVector("Cz", czVal);
		CzTabIhm.addGInterval(errInterval);
		
		aeroTabIhm=new GTable1D(
				"Cx/Cz = f(Mach)", TableOrientation.VERTICAL,incTabIhm, CxTabIhm, CzTabIhm);
		aeroTabIhm.setConstraint(new GConstraint(GConstraint.newline()));

		aeroTabIhm.setNameInConfigFile("AERO");
		
		butDisp = new GButton("Display ...");

	}

	public void display() throws GException { generic(); }

	public void generic() throws GException {
		put(aeroTabIhm);
		put(butDisp);
	}
	
	public void after(GEvent arg0) {

		if ( arg0.contains(butDisp) ) {
			double[] aoaTab = this.getData(0);
			double[] cxTab = this.getData(1);
			for (int i = 0; i < cxTab.length; i++) {
				System.out.println(aoaTab[i]+" "+cxTab[i]);
			}
		}
		
	}
	
	public void before(GEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public double[] getData ( int rank ) {
		double[] tmp = new double[aeroTabIhm.getGVector(rank).size()];
		for (int i = 0; i < tmp.length; i++) {
			tmp[i] = (Double)aeroTabIhm.getGVector(rank).getValue(i);
		}
		return tmp;
	}
	
	public static void main(String[] args) throws GIntervalException {

		TestForGTable1D test = new TestForGTable1D();

		GPanTest panTest = new GPanTest("Test GTable", test);
		panTest.getJFrame().setPreferredSize(new Dimension(550, 450));

		panTest.display();
		
	}

}
