import java.awt.Dimension;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GTabbedPane;
import fr.cnes.genius.utils.GPanTest;

/**
 * Testing GTabbedPane and tooltips
 * @author goesterjf
 *
 */
public class TestForGTabbedPaneAndToolTip extends GPanel {
	
	GTabbedPane tabs;
	
	GLabel lab1;
	GLabel lab2;
	GLabel lab3;
	
	GEntryInt valI;
	GEntryReal valR;
	
	public TestForGTabbedPaneAndToolTip () throws GException {
		
		tabs = new GTabbedPane("Tabbedpane");
		tabs.setConstraint(new GConstraint(GConstraint.grow(), GConstraint.push()));

		lab1 = new GLabel("Tab 1 ...");
		lab2 = new GLabel("Tab 2 ...");
		lab3 = new GLabel("Tab 3 ...");
		
		valI = new GEntryInt("Integer :", 123);
		valI.setToolTipText("This is an integer");
		valI.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(50), GConstraint.split(2)), 0, 0);
		valI.setInnerDescendantConstraint(new GConstraint(GConstraint.gaptop(50)), 1);
		valR = new GEntryReal("Real :", 3.14);
		valR.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(50), GConstraint.split(2)), 0, 0);
		valR.setInnerDescendantConstraint(new GConstraint(GConstraint.gaptop(50)), 1);
		valR.setToolTipText("This is an real");
	
		tabs.addTab("Tab 1", new GPanel() {
			public void display() throws GException { generic(); }
			@Override
			public void generic() throws GException { put(lab1); }

		});
		
		tabs.addTab("Tab 2", new GPanel() {
			public void display() throws GException { generic(); }
			@Override
			public void generic() throws GException { put(lab2); }
		});
		
		tabs.addTab("Tab 3", new GPanel() {
			public void display() throws GException { generic(); }
			@Override
			public void generic() throws GException {
				put(lab3);
				put(valI);
				put(valR);
				}
		});
		
		tabs.getJTabbedPane().setSelectedIndex(1);
		tabs.getJTabbedPane().setEnabledAt(0, false);
		
	}

	public void display() throws GException { generic(); }

	@Override
	public void generic() throws GException {
		put(tabs);
	}
	
	public void read() throws GException { generic(); }

	public void write() throws GException { generic(); }

	/**
	 * @param args
	 * @throws GException 
	 */
	public static void main(String[] args) throws GException {

		TestForGTabbedPaneAndToolTip test = new TestForGTabbedPaneAndToolTip();

		GPanTest panTest = new GPanTest("TestForGTabbedPaneAndToolTip", test);
		panTest.getJFrame().setPreferredSize(new Dimension(550, 450));

		panTest.display();


	}

}
