
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GOpenCloseButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;

/**
 * Testing OPenClose buttons.
 * @author goesterjf
 *
 */
public class TestForGOpenCloseButton extends GPanel {
	
	private GOpenCloseButton but;
	private GEntryReal val1;
	private GEntryReal val2;
	
	public TestForGOpenCloseButton() throws GIntervalException {
		but = new GOpenCloseButton();
		but.setConstraint(new GConstraint(GConstraint.newline(false)));
		val1 = new GEntryReal("val1 entry:", 1.);
		val2 = new GEntryReal("val2 entry:", 1.);
		val2.setEnabled(false);

	}

	public void generic() { }

	public void display() throws GException {
		put(val1);
		put(but);
		if ( but.isExpanded() ) {
			put(val2);
		}
	}
	
	/**
	 * @param args
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
		TestForGOpenCloseButton pan = new TestForGOpenCloseButton();
		GFrame frame = new GFrame("TestForGOpenCloseButton", pan);	
		frame.display();
	}

}
