import java.awt.Color;

import fr.cnes.genius.chart.GFreeChartXY;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFreeChartException;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;

/**
 * Testing GFreeChartXY
 * @author goesterjf
 *
 */
public class TestForGFreeChartXY extends GPanel {

	private GFreeChartXY plot;
	
	public TestForGFreeChartXY() throws GFreeChartException {
		
		boolean addLegendFlag = true;
		plot = new GFreeChartXY("Main Title", "XAxis Title", "YAxis Title", "Sec YAxis Title", addLegendFlag);
		
		double[] xVal = { 0., 10., 20., 30., 40.};
		double[] yVal = { 0., 2., 4., 9., 16.};
		boolean drawLines = true;
		plot.addSerie("nameOfTheSeries", xVal, yVal, Color.RED, drawLines);
		plot.setSubTitle("SubTitle");
		plot.setXZoom(10., 30.);
		plot.setXTickInterval(2.5);
		plot.showChrossHair(true);
		
	}

	public void generic() { }

	public void display() throws GException {
		put(plot);
	}
	
	/**
	 * @param args
	 * @throws GFreeChartException 
	 */
	public static void main(String[] args) throws GFreeChartException {
		TestForGFreeChartXY pan = new TestForGFreeChartXY();
		GFrame frame = new GFrame("Plots", pan);	
		frame.display();
	}

}
