import java.awt.Dimension;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;

/**
 * Testing Copy & Paste
 * @author goesterjf
 *
 */
public class TestForCopyAndPaste extends GPanel implements GListener, GReadWrite {
	
	private GLabel lab;
	private GEntryReal val1;
	private GEntryReal val2;
	private GEntryString vals;
	private GCheckBox cb;
	
	public TestForCopyAndPaste () {
		
		lab = new GLabel("Label ...");
		val1 = new GEntryReal("Val1", 0.);
		val2 = new GEntryReal("Val2", 0.);
		cb = new GCheckBox("Display String");
		vals = new GEntryString("String", "");
		
		//lab.attachCopyPasteMenu(null, CopyPasteOperation.Copy, CopyPasteOperation.Paste);

	}
	
    public void attachCopyPasteMenu (String title, CopyPasteOperation... operationList) {
    	//lab.attachCopyPasteMenu(title, operationList);
		super.attachCopyPasteMenu(title, operationList);
	}
    
	@Override
	public void generic() throws GException {
		put(lab);
		put(val1);
		put(val2);
		put(cb);
		if ( cb.isSelected() ) put(vals);
	}
	
	@Override
	public void display() throws GException { generic(); }

	@Override
	public void read() throws GException { generic(); }

	@Override
	public void write() throws GException { generic(); }

	@Override
	public void after(GEvent arg0) throws GException {
		
        //boolean cpEvent = handleCopyPasteEvent(lab, arg0);
        boolean cpEvent = handleCopyPasteEvent(this, arg0);

        if ( !cpEvent) {
        	System.out.println("Nothing to do with Copy&Paste ...");
        }
        else {
        	System.out.println("Copy&Paste action ...");
        }
        
	}

	@Override
	public void before(GEvent arg0) throws GException { }

	public static void main(String[] args) throws GException {
		
		TestForCopyAndPaste test = new TestForCopyAndPaste();
		//test.attachCopyPasteMenu("All data", CopyPasteOperation.All);
		test.attachCopyPasteMenu("All data", CopyPasteOperation.Copy, CopyPasteOperation.Paste);

		GFrame frame = new GFrame("TestForCopyAndPasteWidget", test);
		frame.getJFrame().setPreferredSize(new Dimension(350, 200));
		frame.display();

	}

}
