package GTableList;
import java.awt.Dimension;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Testing creation of its own GENIUS object (GTableList with dates inside).
 * @author goesterjf
 *
 */
public class TestForGTableList extends GPanel implements GListener {
	
	private GTableList table;
	
	private GLabel lab; // To test the Layout
	private GCheckBox check; // To test conditional display
	
	public TestForGTableList () {
		
		check = new GCheckBox("Display table");
		check.setSelected(true);
		lab = new GLabel("Label ...");
		
		Object[][] data = { { "01/01/2015", "1", "1.1" }, { "02/01/2015", "2", "2.2" }, { "03/01/2015", "3", "3.3" }, { "04/01/2015", "4", "4.4" }};
		String[] titles = { "Date", "Integer", "Real" };
		
		table = new GTableList(data, titles);
		table.setConstraint(null);
			
	}
		
	@Override
	public void display() throws GException {
		generic();
	}

	@Override
	public void generic() throws GException {
		put(check);
		put(lab);
		if ( check.isSelected() ) {
			put(table);
		}
	}

	@Override
	public void after(GEvent arg0) throws GException {
		
		if ( arg0.contains(table) ) {
			System.out.println("Data is modified ...");
		}
	}

	@Override
	public void before(GEvent arg0) throws GException {
	}

	public static void main(String[] args) {

		TestForGTableList test = new TestForGTableList();
		
		GFrame frame = new GFrame("TestForGTableList", test);
		frame.getJFrame().setPreferredSize(new Dimension(400, 170));
		frame.display();

	}

}
