package GTableList;
import java.awt.Component;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import fr.cnes.genius.main.GComponent;
import fr.cnes.genius.main.GDisplay;
import fr.cnes.genius.main.GEvent;


public class GTableList extends GComponent implements GDisplay, TableModelListener   {
	
	private JTable      m_JTable;
	private JScrollPane m_JScrollPane;
	
	private Object[][] m_data;
	private String[]   m_columnNames;
	
	public GTableList(Object[][] data, String[] columnNames) {
		
		super(null);
		
		m_data = data;
		m_columnNames = columnNames;
		m_JTable = new JTable(m_data, m_columnNames);
		m_JScrollPane = new JScrollPane(m_JTable); // also to get the column names displayed
		
		m_JTable.getModel().addTableModelListener(this);
	}
	
    @Override
    public void display() {
        doDisplay(this);
    }

    @Override
    public Component getComponent() {
        return m_JScrollPane;
    }

	@Override
	public void tableChanged(TableModelEvent e) {

        int row = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = (TableModel)e.getSource();
        Object data = model.getValueAt(row, column);
        System.out.println("New data is "+data);
        
        GEvent gevent = new GEvent();
        processGEvent(gevent, this);
        
	}
    
}
