package GTabbedPaneAndUpdate;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GComboBoxWithLabel;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.observer.GObserver;

/**
 * Standard panel displaying a global variable, a local one and the chosen law.
 * It will observe if the global variable has been modified.
 * @author goesterjf
 *
 */
public class AppliPanStd extends GPanel implements GReadWrite, GObserver {
	
	/** Global double variable */
	private GEntryReal valRGlobal;
	/** Local double variable */
	private GEntryReal valRLocal;
	/** Combo box listing laws */
	private GComboBoxWithLabel combo;
	
	public AppliPanStd () {
		
		valRGlobal = new GEntryReal("Global Real:", 0.);
		valRLocal  = new GEntryReal("Local Real:", 0.);
		combo = new GComboBoxWithLabel("Attitude:", 0, "NONE");

	}

	@Override
	public void generic() throws GException {
		put(valRLocal);
		put(combo);
	}

	@Override
	public void display() throws GException {
		put(valRGlobal);
		generic();
	}

	@Override
	public void read() throws GException {
		generic();
	}

	@Override
	public void write() throws GException {
		generic();
	}

	@Override
	public void notify(Object observable, Object... args) {

		if ( observable instanceof AppliPan0 ) {
			// Update of valR
			final AppliPan0 pan0 = (AppliPan0)observable;
			valRGlobal.setValue( pan0.getCommonRealValue() );
			// Update of the attitude law list
			final int savedValue = combo.getValue();
			final String[] list = pan0.getListOfLawsNames();
			if ( list.length > 0 ) {
				final int[] valueList = new int[list.length];
				for (int i = 0; i < valueList.length; i++) {
					valueList[i] = i;
				}
				combo.setValueList(0, valueList, list);
				combo.setValue(savedValue);
			}
		}

	}

}
