package GTabbedPaneAndUpdate;

import java.util.ArrayList;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GComponentList;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.observer.GObservable;
import fr.cnes.genius.observer.GObserver;
import fr.cnes.genius.observer.GObserverList;

/**
 * Specific panel where are defined:
 * - the amount of tabs
 * - a global double variable
 * - a list of available laws
 * This panel is observed
 * @author goesterjf
 *
 */
public class AppliPan0 extends GPanel implements GListener, GReadWrite, GObservable {
	
	/** Amount of tabs */
	private GEntryInt amountOfTabsEntry;
	/** Global double variable */
	private GEntryReal valR;
	/** List of laws */
	private GComponentList listOfLaws;
	
	private AppliTabbedPane tabPan;
	
    /** Update management */
    private final GObserverList obsList;
    
	public AppliPan0 ( final int nbTabs, final AppliTabbedPane tabPan ) {
		
		amountOfTabsEntry = new GEntryInt("Amount of Pans:", nbTabs);
		
		valR = new GEntryReal("Data to recover:", 0.);
		
		listOfLaws = new GComponentList("Attitude laws", AppliLaw.class, true);
		
		this.tabPan = tabPan;
		
		obsList  = new GObserverList();

	}

	@Override
	public void generic() throws GException {
		put(amountOfTabsEntry);
		put(valR);
		put(listOfLaws);
	}

	@Override
	public void display() throws GException {
		generic();
	}

	@Override
	public void read() throws GException {
		generic();
		// Notifying observers after reading
        obsList.notifyObservers(this);

	}

	@Override
	public void write() throws GException {
		// Notifying observers before writing
        obsList.notifyObservers(this);
		generic();
	}

	@Override
	public void before(GEvent arg0) throws GException {
	}

	@Override
	public void after(GEvent arg0) throws GException {
        if ( arg0.contains(amountOfTabsEntry) ) {
        	// Managing the amount of tabs
        	tabPan.manageAmountOfPans(this.getAmountOfTabs());
        }
		if ( arg0.contains(valR, listOfLaws)) {
			// We notify to observers that a change occurred.
			notifyObservers();
		}
	}

	@Override
	public void registerObserver(GObserver observer) {
        obsList.registerObserver(observer);
		
	}

	@Override
	public void unregisterObserver(GObserver observer) {
        obsList.unregisterObserver(observer);
		
	}

	@Override
	public void notifyObservers(Object... args) {
		obsList.notifyObservers(this, args);
	}

    
	public GEntryInt getAmountOfTabsEntry() {
		return amountOfTabsEntry;
	}

	public int getAmountOfTabs() {
		return amountOfTabsEntry.getValue();
	}

	public double getCommonRealValue() {
		return valR.getValue();
	}
	
	/**
	 * Method to get the list of attitude laws.
	 * @return list of attitude laws
	 */
	public String[] getListOfLawsNames () {
		
		final ArrayList<AppliLaw> list = listOfLaws.getList();
		String[] stringList = new String[list.size()];
		for (int i = 0; i < list.size(); i++) {
			stringList[i] = list.get(i).getName();
		}
		
		return stringList;
		
	}

}
