package GStandardApplication.ihm;

import java.awt.Font;
import java.io.File;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.savefiles.GSaveResults;
import fr.cnes.genius.standardapplication.GAboutDialog;
import fr.cnes.genius.standardapplication.GMainFrameAbstract;
import fr.cnes.genius.utils.GContextFileManagement;
import fr.cnes.genius.utils.GFileFilter;

/**
 * Main frame
 * @author goesterjf
 *
 */
public class WidSW extends GMainFrameAbstract<WidSWDataPanel> {

    // File Names
    /** Prefix for context file names */
    private static final String INI_FILE_PREFIX = "INI_";
    /** By default context file names */
    private static final String INI_FILE = "INIT.xml";
    /** Prefix for output file names */
    private static final String EPH_FILE_PREFIX = "EPH_";
    /** Prefix for output file names */
    private static final String EVE_FILE_PREFIX = "EVE_";
    /** By default EPHEM file names */
    private static final String EPH_FILE = "EPHEM.txt";
    /** By default EVENT file names */
    private static final String EVE_FILE = "EVENT.txt";
    
    /** Initial files directory */
    private static final String tmpdirName = "src/GStandardApplication/";
  
    // SIZES
    /** Data panel height */
    private static final int DATAPANEL_HEIGHT = 400;
    /** Error console height */
    private static final int ERRCONSOLE_HEIGHT = 80;
    /** Icon size */
    private static  final int ICON_SIZE = 12;
    /** Font size */
    private static final int FONT_SIZE = 12;
    
    /**
     * Constructor
     * @throws GException GENIUS exception
     */
    public WidSW() throws GException {
        
        super("S/W",
        	  new WidSWDataPanel(),
              new GContextFileManagement(tmpdirName, "SW", new GFileFilter(INI_FILE_PREFIX, ".xml", "S/W Files") ),
              new GAboutDialog("About S/W", "Example S/W ...", "CNES", "Vx.x ; xx/xx/2017", "/GStandardApplication/images/logoCNES.jpg"),
              new GSaveResults("Saving SW results", new File(tmpdirName+"results"),".txt", ".xml"),
              DATAPANEL_HEIGHT, ERRCONSOLE_HEIGHT, ICON_SIZE, true);
        
        Font font = new Font("Courier", Font.PLAIN, FONT_SIZE);
        this.getDataPanel().setConsoleFont(font);
        this.setErrConsoleFont(font);
        
    }
    
    /**
     * Method managing the results (and context) files saving.
     */
    @Override
    protected void saveFilesManagement() throws GException {
        
        final File ini = new File(tmpdirName+"data/", INI_FILE);
        final File res = new File(tmpdirName+"results/", EPH_FILE);
        final File eve = new File(tmpdirName+"results/", EVE_FILE);
        
        // The context file will be saved as the result file
        this.getSaveResultsDialog().setContextFile("../data/"+ini.getName(), INI_FILE_PREFIX, true);
        // Result files consist in two files named by default "EPHEM.txt" and "EVENT.xml"
        this.getSaveResultsDialog().clearResultFileList();
        this.getSaveResultsDialog().addSingleResultFile(res.getAbsolutePath(), EPH_FILE_PREFIX, true);
        this.getSaveResultsDialog().addSingleResultFile(eve.getName(), EVE_FILE_PREFIX, true);
        this.getSaveResultsDialog().show();
        
    }
    
    /**
     * Method for pre processing management just before running computation.
     */
    @Override
    protected void customPreProcessManagement() throws GFileManipulatorException {
        
        // We write a context file with data coming from the data panel
    	GFileManipulation.writeConfig(tmpdirName+"data/"+INI_FILE, "SW", this.getDataPanel(), true);
    	// We initialize the JavaCommandLauncher
        final String classPath = System.getProperty("java.class.path");
        this.getJavaCommandLauncher().setJavaCommand(classPath, new String[] {"GStandardApplication.ihm.BatchSW",
                                                    "-i", tmpdirName+"data/"+INI_FILE,
                                                    "-e", tmpdirName+"results/"+EPH_FILE});
        // We display the console above the other tabbedpanes
        this.getDataPanel().selectConsoleTab();
        
    }
    
    /**
     * Method for post processing management.
     */
    @Override
    protected void customPostProcessManagement() {
    	// Nothing to do ...
    }
    
    /**
     * Main method used to launch the DOORS GUI.
     * @param args              No arguments used up to now.
     * @throws OrekitException  OREKIT exception
     * @throws GException       GENIUS exception
     */
    public static void main(String[] args) throws GException {

        final WidSW pan = new WidSW();
        pan.displayMainFrame();
        
    }



}
