package GStandardApplication.ihm;

import java.io.IOException;
import java.util.logging.Level;

import GStandardApplication.calc.SW;
import GStandardApplication.calc.Vehicle;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.interval.GIntervalAbstract.GStatus;
import fr.cnes.genius.loggers.GConsoleLogger;
import fr.cnes.genius.main.GFileManipulation;

/**
 * Class to tun SW via batch mode (reading before XML context file).
 * @author goesterjf
 *
 */
public class BatchSW {
    
    /** Computation object ("subroutine" mode) */
    SW sw;

    /**
     * Constructor
     * @param nomFicData    name of the context file.
     * @param nomFicEphem   name of the output file.
     * @throws IOException  GENIUS exception.
     */
    public BatchSW (final String nomFicData, final String nomFicEphem) throws IOException {
        
        WidSWDataPanel dataPan = null;
        
        try {
            
            dataPan = new WidSWDataPanel();
            
            // Data reading inside the XML file
            GFileManipulation.readConfig(nomFicData, "SW", dataPan, true);
            
            if ( dataPan.getStatus() == GStatus.ERROR ) {
                
                GConsoleLogger.getLogger().log(Level.SEVERE, "there are some erroneous data ...");
                
            } else {
                
                if ( dataPan.getStatus() == GStatus.WARN ) {
                    GConsoleLogger.getLogger().log(Level.WARNING, "some data raised warning ...");
                }

                // SW initialization
                Vehicle veh = dataPan.getVehicle();
                sw = new SW(veh, nomFicEphem);
            }
            
        } catch (GException err) {
            GConsoleLogger.getLogger().log(Level.SEVERE, err.getMessage());
        }
        
    }

    /**
     * Method to compute.
     */
    public void compute () {
        sw.compute();
    }


    /**
     * @param args
     */
    public static void main(String[] args) {

        // Recovery of the file names eventually thanks to the arguments.
        String nomFicData  = "src/GStandardApplication/data/INIT.xml";
        String nomFicEphem  = "src/GStandardApplication/results/EPHEM.txt";
        
        // Loop on arguments
        boolean gap = false;
        for (int i = 0; i < args.length; i++) {
            if ( gap == false ) {
                if ( "-i".equals(args[i]) ) {
                    nomFicData = args[i+1];
                    gap = true;
                }
                if ( "-e".equals(args[i]) ) {
                    nomFicEphem = args[i+1];
                    gap = true;
                }
            } else {
                gap = false;
            }
                
        }
        
        BatchSW batch;
        try {
            batch = new BatchSW(nomFicData, nomFicEphem);
            batch.compute();
        } catch (IOException e) {
            e.printStackTrace();
        }
        
    }

}
