package GStandardApplication.calc;

import java.io.FileWriter;
import java.io.IOException;

/**
 * "Subroutine" computation mode.
 * @author goesterjf
 *
 */
public class SW {
    
    /** Vehicle object */
    private final Vehicle vehicle;
    
    /** EPHEM file name */
    private final String ephemFileName;

    /**
     * Constructor
     * @param vehicle         vehicle data.
     * @param ephemFileName   ephemeris file name.
     */
    public SW ( Vehicle vehicle,  String ephemFileName ) {
        
        this.vehicle = vehicle;
        this.ephemFileName = ephemFileName;
    }
    
    /**
     * Method to compute ("subroutine" mode).
     */
    public void compute () {
    	
    	FileWriter ephemFile = null;
    	try {
    		ephemFile = new FileWriter(ephemFileName);
            ephemFile.write("Initial total mass: " + vehicle.getTotalMass()+"\n");
		} catch (IOException e1) {
			e1.printStackTrace();
		}
        
        System.out.println("Initial total mass:" + vehicle.getTotalMass());
        
        for (int i = 0; i < 10; i++) {
            
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("@"+(int)((i+1)*10)+"@");
            System.out.println(i);
            try {
            	ephemFile.write(i+"\n");
			} catch (IOException e) {
				e.printStackTrace();
			}

        }
        
        try {
            ephemFile.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

}
