package GProgressBar;
import java.io.UnsupportedEncodingException;


import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.main.GEnvironment;
import fr.cnes.genius.main.GFileManipulation;

/**
 * Computation class sending information for process bar
 * @author goesterjf
 *
 */
public class TestForGProgressBarCompute {

	public static void main(String[] args) throws UnsupportedEncodingException, InterruptedException, GFileManipulatorException {

		GEnvironment.setOutputEncoding("UTF-8");
		
		TestForGProgressBar widget = new TestForGProgressBar();	
		GFileManipulation.readConfig("TestForGProgressBar.xml", "localTest", widget, false);
		
		double dMax = (double)widget.getIMax();
		for (int i = 0; i < widget.getIMax(); i++) {
			Thread.sleep(1000);
			double progress = 100.*(i+1)/dMax;
			System.out.println("@"+(int)progress+"@");
		}


	}

}
