package GProgressBar;
import java.awt.Dimension;
import java.io.UnsupportedEncodingException;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.lowLevel.GIcon;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GProgressBar;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.threads.GCommandLauncher.GExecButton;
import fr.cnes.genius.threads.GCommandLauncher.ProcessStatus;
import fr.cnes.genius.threads.GJavaCommandLauncher;
import fr.cnes.genius.utils.GPanTest;

/**
 * Testing progress bar.
 * @author goesterjf
 *
 */
public class TestForGProgressBar extends GPanel implements GListener, GReadWrite {
	
	private GEntryInt iMax;
	private GJavaCommandLauncher cmd;
	private GExecButton but;
	private GProgressBar pBar;
	
	private boolean flagLaunchByEntry;
	
	public TestForGProgressBar () throws UnsupportedEncodingException {
		
		iMax = new GEntryInt("NbMax:", 0);
		iMax.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.split(3), GConstraint.gaptop(10)), 0, 0);
		iMax.setInnerDescendantConstraint(new GConstraint(GConstraint.gaptop(10)), 1);
		
		String path = System.getProperty("java.class.path");
		
		cmd = new GJavaCommandLauncher(new String[] {"GProgressBar.TestForGProgressBarCompute", "TestForGProgressBar.xml"}, path, "Launch", "Stop", null);
		cmd.setButtonIcons(new GIcon(GIcon.Type.START, 12), new GIcon(GIcon.Type.STOP, 12));
		but = cmd.getGExecButton();
		
		pBar = cmd.getGProgressBar();
		pBar.getJProgressBar().setPreferredSize(new Dimension(250, 30));
		pBar.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.spanx(2), GConstraint.growx(), GConstraint.gaptop(10)));
		
		flagLaunchByEntry = false;
		
	}
	
	public void generic() throws GException {
		put(cmd);
		put(but);
		put(iMax);
		put(pBar);
	}
	
	public void display() throws GException { generic(); }

	public void read() throws GException { generic(); }

	public void write() throws GException { generic(); }
	
	private void preLaunch () throws GFileManipulatorException {
		if ( ! cmd.isRunning() ) {
			if ( iMax.getValue() <= 0 ) {
				System.out.println("Inhibition of the computation ...");
				cmd.setInhibited(true);
			}
			else {
				prepareInputFile();
			}
		}
	}
	
	private void prepareInputFile () throws GFileManipulatorException {
		if ( iMax.getValue() > 0 ) {
			System.out.println("Start loading data ...");
			GFileManipulation.writeConfig("TestForGProgressBar.xml", "localTest", this, false);	
		}
	}

	public void before(GEvent e) throws GException {

		if ( e.contains(but) ) {
			System.out.println(flagLaunchByEntry);
			if ( flagLaunchByEntry ) {
				if ( cmd.isRunning() ) cmd.setInhibited(true);
				flagLaunchByEntry = false;
			}
			else {
				preLaunch();	
			}
		}
		
	}

	public void after(GEvent e) throws GException {
		
		if ( (e.getFinalSource() == cmd ) )	{
			
			System.out.println("e.getFinalSource() == cmd ... "+cmd.getProcessStatus());

			if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_NORMALY ) {
				System.out.println("Computation nominally stopped ...");
				flagLaunchByEntry = false;
			}
			else if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_BY_USER ) {
				System.out.println("Computation stopped by user ...");
				pBar.setValue(0);
				flagLaunchByEntry = false;
			}
			
		}
		
		if ( e.contains(iMax) ) {
			preLaunch();
			cmd.launchStop();
			flagLaunchByEntry = true;
			System.out.println(flagLaunchByEntry);
		}
		
	}
	
	public int getIMax () { return iMax.getValue(); }
	
	/**
	 * @param args
	 * @throws InterruptedException 
	 * @throws UnsupportedEncodingException 
	 */
	public static void main(String[] args) throws InterruptedException, UnsupportedEncodingException {
		
		TestForGProgressBar pan = new TestForGProgressBar();
		GPanTest test = new GPanTest("TestForGProgressBar", pan, "TestForGProgressBar.xml");
		test.setMinimumSize(new Dimension(400, 250));
		test.display();
		
	}

}
