package GFrameExit;

import java.awt.Dimension;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * testing Frame exit.
 * @author goesterjf
 *
 */
public class TestForFrameExit extends GFrame implements GListener {
	
	private TestForFrameExitDialog dialog;
	
	public TestForFrameExit ( TestForFrameExitPanel pan ) {
		
		super("TestForFrameExit", pan);
		
		this.getJFrame().setPreferredSize(new Dimension(350, 200));
		this.setDefaultCloseOperation(CloseAction.DoNothinOnClose);
		
		dialog = new TestForFrameExitDialog("Dialog");

	}

	@Override
	public void before(GEvent arg0) throws GException { }

	@Override
	public void after(GEvent arg0) throws GException {
		
		if ( arg0.contains(this) ) {
			dialog.show();
			if ( dialog.isExit() ) {
				System.out.println("Exit with x");
				System.exit(0);
			}
		}
		
	}

	/**
	 * @param args
	 * @throws GException 
	 */
	public static void main(String[] args) throws GException {
		
		TestForFrameExitPanel pan = new TestForFrameExitPanel();
		TestForFrameExit test = new TestForFrameExit(pan);		
		test.display();


	}

}
