package GCondensedStatus;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.interval.GInterval;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GCondensedStatus;
import fr.cnes.genius.main.GCondensedStatusInterface;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;

public class TestForCondensedStatusWidget extends GPanel implements GCondensedStatusInterface {
	
	private final String name;
	private final GEntryReal valAngle;
	private final GEntryReal valDist;
	
	private final GUnit[] unitAngle = {new GMetricUnit("deg"), new GMetricUnit("rad")};
	private final GUnit[] unitDist = {new GMetricUnit("km"), new GMetricUnit("m")};
	public final GInterval angleInterval =
			new GInterval(Math.toRadians(30.), Math.toRadians(60.), GInterval.Rule.INCLUSIVE, GInterval.Rule.EXCLUSIVE,
					      Math.toRadians(0.),  Math.toRadians(90.), GInterval.Rule.INCLUSIVE, GInterval.Rule.EXCLUSIVE);
	public final GInterval distInterval =
			new GInterval(100.e+3, 1000.e+3, GInterval.Rule.INCLUSIVE, GInterval.Rule.INCLUSIVE,
					      0.,     36000.e+3, GInterval.Rule.INCLUSIVE, GInterval.Rule.INCLUSIVE);
	
	public TestForCondensedStatusWidget( final String name ) throws GIntervalException {
		this.name = name;
		valAngle = new GEntryReal("Angle entry", Math.toRadians(45.), unitAngle);
		valAngle.addGInterval(angleInterval);
		valDist = new GEntryReal("Distance entry", 500.e+3, unitDist);
		valDist.addGInterval(distInterval);
	}

	public void generic() throws GException {
		beginOfElement("wid", "wid"+name);
		put(valAngle);
		put(valDist);		
		endOfElement();
	}

	public void display() throws GException {
		generic();
	}
	
	@Override
	public void updateCondensedStatus(GCondensedStatus arg0) {
		arg0.update(valAngle, valDist);	
	}

}
