import java.io.File;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.SqliteException;
import fr.cnes.genius.sqlite.ColumnInfo.ColumnType;
import fr.cnes.genius.sqlite.ResultWriter;

/**
 * Class to test SQLITE writer.
 * @author goesterjf
 *
 */
public class TestForWritingSqlLite {
    
    /**
     * @param args
     * @throws GException 
     * @throws SqliteException 
     */
    public static void main(String[] args) throws GException, SqliteException {
        
        // Data initialization
        
        final String NAME_EPHEM_TABLE = "ephemTable";
        final String NAME_EVENT_TABLE = "eventTable";
        
        final int nbColumnsSql = 3;
    
        final String[] dataNames = { "TIME", "LATG", "LONG" };
        final Double[]  gapThresholds = { 1.e+99, Math.PI, Math.PI };
        final String[]  unitNames = { "s", "deg", "deg" };
        final String[]  description = { "Time", "Latitude", "Longitude" };
        
        final int nbPtsEphem = 5;
        final double[] timeTable = { 0., 10., 20., 30., 40. };
        final double[] latgTable = { -0.5*Math.PI, -0.25*Math.PI, 0.,  0.25*Math.PI, 0.5*Math.PI };
        final double[] longTable = { -Math.PI, -0.5*Math.PI, 0.,  0.5*Math.PI, Math.PI};
        
        final int nbPtsEvent = 2;
        final double[] timeTableEvent = { 0., 40. };
        final double[] latgTableEvent = { -0.5*Math.PI, 0.5*Math.PI };
        final double[] longTableEvent = { -Math.PI, Math.PI};
        
        // File creation and reset if it already exists
        
        final File sqliteFile = new File("EPHEM.db");
        if ( sqliteFile.exists() && !sqliteFile.delete() ) {
            System.out.println("Sqlite output file failed to delete: %s");
        }

        final ResultWriter  resultWriter = new ResultWriter(sqliteFile);
        resultWriter.open();
        
        // Table configuration
        resultWriter.addTable (NAME_EPHEM_TABLE);
        resultWriter.addTable (NAME_EVENT_TABLE);         
         
        // Columns configuration
        /// Note: 
        // gapThreshold is the value given for plot discontinuities
        // userVisible may be used to add columns but not visible via the GUI (for example for plotting).
        for (int i = 0; i < nbColumnsSql; i++) {
            resultWriter.addColumn(NAME_EPHEM_TABLE, dataNames[i], description[i], ColumnType.REAL, unitNames[i], gapThresholds[i], true);
            resultWriter.addColumn(NAME_EVENT_TABLE, dataNames[i], description[i], ColumnType.REAL, unitNames[i], gapThresholds[i], true);
        }
         
        // Adding values for each line
        // Note: each table is independant and one may fill them asynchroneously.
        for (int i = 0; i < nbPtsEphem; i++) {
            // Note: it is mandatory to add a value for each column. If it is not the case, it will raise an error.
            // On the other hand, if we add two times a value for the same line/column, the last value will be taken into account.
            resultWriter.addValue(NAME_EPHEM_TABLE, dataNames[0], timeTable[i]);                          
            resultWriter.addValue(NAME_EPHEM_TABLE, dataNames[1], latgTable[i]);                          
            resultWriter.addValue(NAME_EPHEM_TABLE, dataNames[2], longTable[i]);                          
            // Line is stored in the database
            resultWriter.writeLine(NAME_EPHEM_TABLE);
        }
        
        // Same for events
        for (int i = 0; i < nbPtsEvent; i++) {
            resultWriter.addValue(NAME_EVENT_TABLE, dataNames[0], timeTableEvent[i]);                          
            resultWriter.addValue(NAME_EVENT_TABLE, dataNames[1], latgTableEvent[i]);                          
            resultWriter.addValue(NAME_EVENT_TABLE, dataNames[2], longTableEvent[i]);                          
            resultWriter.writeLine(NAME_EVENT_TABLE);
        }
         
        // Closing the data base
        resultWriter.close();

    }

}
