
import fr.cnes.genius.exception.GEntryRealException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GComboBoxWithLabel;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.interval.GInterval;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.unit.GUnitFactory;

/**
 * Testing validity intervals
 * @author goesterjf
 *
 */
public class TestForValidityIntervals extends GPanel {
	
	private GEntryReal val;
	private GComboBoxWithLabel combo;
	
    //private GUnit[] unitAngle = {new GMetricUnit("deg"), new GMetricUnit("rad")};
    private GUnit[] unitAngle = GUnitFactory.getGUnitArray("deg", "rad");
	public final GInterval angleInterval =
			new GInterval(Math.toRadians(30.), Math.toRadians(60.), GInterval.Rule.INCLUSIVE, GInterval.Rule.EXCLUSIVE,
					Math.toRadians(0.), Math.toRadians(90.), GInterval.Rule.INCLUSIVE, GInterval.Rule.EXCLUSIVE);

	
	public TestForValidityIntervals() throws GIntervalException {
		
		val = new GEntryReal("Angle entry:", Math.toRadians(45.), unitAngle);
		val.addGInterval(angleInterval);
		try {
			val.setFracDigits(10);
		} catch (GEntryRealException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		combo = new GComboBoxWithLabel("Combo", 1, "NONE", "Law 1", "Law 2");
		combo.setErrorLabelsList("NONE");
		combo.setWarningLabelsList("Law 2");

	}

	public void generic() { }

	public void display() throws GException {
		put(val);
		put(combo);
	}
	
	/**
	 * @param args
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
		TestForValidityIntervals pan = new TestForValidityIntervals();
		GFrame frame = new GFrame("TestForValidityIntervals", pan);	
		frame.display();
	}

}
