import java.io.File;
import java.util.List;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.SqliteException;
import fr.cnes.genius.plots.GPlotColumnInfo;
import fr.cnes.genius.plots.GPlotDataMadonaReader;

/**
 * Class to test MADONA files reader.
 * @author goesterjf
 *
 */
public class TestForReadingMadonaFile {
    
    /**
     * @param args
     * @throws GException 
     * @throws SqliteException 
     */
    public static void main(String[] args) throws GException, SqliteException {
        
        // Opening it and load data
        final GPlotDataMadonaReader fileData = new GPlotDataMadonaReader();
        fileData.load(new File("EPHEM.txt"));
        
        // Recovery of the colums information
        final int nbColumnsMadona = fileData.getNumberColums(null);
        
        // Loop on the columns
        for (int i = 0; i < nbColumnsMadona; i++) {
            
            final GPlotColumnInfo colInfo = fileData.getColumnInfo(null, i);
            System.out.print("Index: " + colInfo.getIndex());
            System.out.print(" / Name: " + colInfo.getName());
            System.out.print(" / Unit: " + colInfo.getUnitName());
            System.out.println(" / Description: " + colInfo.getDesc());
            
        }
        
        // We recover only colums 2, 12, 13 & 14
        final List<Double[]> dataEphem = fileData.getColumns(null, new Integer[] { 1, 12, 13, 14 });
        
        final int nbLines = dataEphem.get(0).length;
        System.out.println("Amount of lines of data: " + nbLines);
        
        System.out.println(String.format("%s %10e %10e %10e %10e", "First line: ",
                dataEphem.get(0)[0],
                dataEphem.get(1)[0],
                dataEphem.get(2)[0],
                dataEphem.get(3)[0]));
        System.out.println(String.format("%s %10e %10e %10e %10e", "Last line: ",
                dataEphem.get(0)[nbLines-1],
                dataEphem.get(1)[nbLines-1],
                dataEphem.get(2)[nbLines-1],
                dataEphem.get(3)[nbLines-1]));

    }

}
