

import java.io.IOException;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEnvironment;

/**
 * Test for using an icon for the application.
 * @author goesterjf
 *
 */
public class TestForIcon extends GPanel {
	
	private GButton but;
	private GEntryString str;
	private GEntryInt ent;
	private GEntryReal val;
	private GCheckBox che;
	private GLabel lab;
	
	/**
	 * Constructor
	 */
	public TestForIcon() {
		but = new GButton("Button");
		str = new GEntryString("Character string entry:", "text");
		ent = new GEntryInt("Integer entry:", 123);
		val = new GEntryReal("Real entry:", 99.);
		che = new GCheckBox("Boolean");
		che.setSelected(true);
		lab = new GLabel("This is a label ...");
	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }

	/**
	 * Display method override.
	 */
	public void display() throws GException {
		put(but);
		put(str);
		put(ent);
		put(val);
		put(che);
		put(lab);
	}
	
	/**
	 * Main method
	 * @param args	no args ...
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
	    
        GEnvironment.setIcon("/images/LogoPsimu.png");

		TestForIcon pan = new TestForIcon();
		GFrame frame = new GFrame("TestForIcon", pan);	
		frame.display();
	}

}
