
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;

/**
 * Testing global constraints
 * @author goesterjf
 *
 */
public class TestForGlobalConstraint extends GPanel {
	
	private GEntryReal val1;
	private GEntryReal val2;
	private GEntryReal val3;
	
	public TestForGlobalConstraint() throws GIntervalException {
		val1 = new GEntryReal("val1 entry:", 1.);
		val2 = new GEntryReal("val2 entry:", 1.);
		val3 = new GEntryReal("val3 entry:", 1.);
	}

	public void generic() { }

	public void display() throws GException {
		put(val1);
		put(val2);
		put(val3);
	}
	
	/**
	 * @param args
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
		TestForGlobalConstraint pan = new TestForGlobalConstraint();
		GConstraint constraint = new GConstraint(GConstraint.newline(), GConstraint.height(50));
		pan.setInnerDescendantClassConstraint(constraint, GEntryReal.class, 1);
		GFrame frame = new GFrame("TestForGlobalConstraint", pan);	
		frame.display();
	}

}
