
import java.awt.Dimension;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.plots.GPlotPanel;

/**
 * Testing GPlotPanel
 * @author goesterjf
 *
 */
public class TestForGPlotPanel extends GPanel implements GListener {
	
	private final GPlotPanel plots;
	
	public TestForGPlotPanel() throws GIntervalException {
        plots = new GPlotPanel("EPH", "", "Ephemeris file", 2, true);
	}

	public void generic() throws GException {
		put(plots);
	}

	public void display() throws GException {
		generic();
	}
	
    @Override
    public void after(GEvent arg0) throws GException {
        if ( arg0.contains(plots)) {
            System.out.println("Amount of detached plots: "+plots.getDetachedPlotList().size());
        }
        
    }

    @Override
    public void before(GEvent arg0) throws GException {
    }

	/**
	 * @param args
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
		TestForGPlotPanel pan = new TestForGPlotPanel();
		GFrame frame = new GFrame("TestForGPlotPanel", pan);	
		frame.setPreferredSize(new Dimension(800, 650));
		frame.display();
	}

}
