import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;

import fr.cnes.genius.chart.GFreeChartXY;
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFreeChartException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Testing GFreeChartXY with updates.
 * @author goesterjf
 *
 */
public class TestForGFreeChartXYUpdate extends GPanel implements GListener {

	/** entrey for a new abscissa */
	private final GEntryReal newValX;
	/** Plot window */
	private GFreeChartXY plot;
	
	/** Data stored in lists */
	private final ArrayList<Double> xValList;
	private final ArrayList<Double> yValList;
	/** Data stored in tables */
	private double[] xValTab;
	private double[] yValTab;

	/**
	 * Constructor.
	 * @throws GFreeChartException
	 */
	public TestForGFreeChartXYUpdate() throws GFreeChartException {
		
		// Entry real initialization
		newValX = new GEntryReal("New abscissa to add to the plot:", 0.);
		
		// Plot initialization
		boolean addLegendFlag = true;
		plot = new GFreeChartXY("y = x^2", "x", "y", null, addLegendFlag);
		plot.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.spanx(99)));
		
		xValList = new ArrayList<Double>();
		yValList = new ArrayList<Double>();
		for (int i = 0; i < 5; i++) {
			addData(i);
		}
		convertListToTable();
		
		plot.addSerie("Square", xValTab, yValTab, null, Color.RED, null);
		
	}
	
	/**
	 * Adding a data to the list.
	 * @param val	value to add.
	 */
	private void addData ( final double val ) {
		// Adding values
		xValList.add(val);
		yValList.add(val*val);
		// Sorting the lists
		Collections.sort(xValList);		
		Collections.sort(yValList);		
	}

	/**
	 * Convert the list in a table.
	 */
	private void convertListToTable () {
		xValTab = new double[xValList.size()];
		yValTab = new double[yValList.size()];
		for (int i = 0; i < xValList.size(); i++) {
			xValTab[i] = xValList.get(i);
			yValTab[i] = yValList.get(i);
		}
		
	}

	public void generic() { }

	public void display() throws GException {
		put(newValX);
		put(plot);
	}
	
	@Override
	public void before(GEvent arg0) throws GException {
		// Nothing to do ...
	}

	@Override
	public void after(GEvent arg0) throws GException {
		if ( arg0.contains(newValX)) {
			addData(newValX.getValue());
			convertListToTable();
			plot.removeSeries("Square", false);
			plot.addSerie("Square", xValTab, yValTab, null, Color.RED, null);
		}
		
	}

	/**
	 * @param args
	 * @throws GFreeChartException 
	 */
	public static void main(String[] args) throws GFreeChartException {
		TestForGFreeChartXYUpdate pan = new TestForGFreeChartXYUpdate();
		GFrame frame = new GFrame("Plots", pan);	
		frame.display();
	}

}
