import java.awt.Dimension;
import java.util.Date;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryDate;
import fr.cnes.genius.lowLevel.GDateField;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;

/**
 * Testing GDate
 * @author goesterjf
 *
 */
public class TestForGDate extends GPanel implements GListener, GReadWrite {
	
	private GEntryDate dat1;
	private GDateField dat2;
	
	public TestForGDate () {
		
		dat1 = new GEntryDate("Date:", "01/01/2015 00h00m00s000");
		dat2 = new GDateField(new Date(dat1.getValue().getTime()));
		dat2.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.skip(1)));

	}
	
	@Override
	public void generic() throws GException {
		put(dat1);
		put(dat2);
	}
	
	@Override
	public void display() throws GException { generic(); }

	@Override
	public void read() throws GException { generic(); }

	@Override
	public void write() throws GException { generic(); }


	@Override
	public void after(GEvent arg0) throws GException {
		if ( arg0.contains(dat1)) {
			System.out.println(((Date)dat1.getValue()).getTime());
		}
		else if ( arg0.contains(dat2)) {
			System.out.println(((Date)dat2.getValue()).getTime());
		}
	}

	@Override
	public void before(GEvent arg0) throws GException { }


	/**
	 * @param args
	 * @throws GException 
	 */
	public static void main(String[] args) throws GException {
		
		TestForGDate test = new TestForGDate();

		GFrame frame = new GFrame("TestForGDtate", test);
		frame.getJFrame().setPreferredSize(new Dimension(350, 200));
		frame.display();

	}

}
