package GTabbedPaneAndUpdate;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;

/**
 * Panel that defines a "law" (for example an attitude law).
 * @author goesterjf
 *
 */
public class AppliLaw extends GPanel implements GReadWrite {
	
	/** Name of the law */
	private final GEntryString name;
	/** Double value corresponding to the law */
	private final GEntryReal val;
	
	public AppliLaw () {
		
		name = new GEntryString("Name of the law:", "law");
		name.setNameInConfigFile("name");
		val  = new GEntryReal("Value:", 0.);
		val.setNameInConfigFile("val");
	}

	@Override
	public void display() throws GException {
		generic();
	}

	@Override
	public void generic() throws GException {
		put(name);
		put(val);
	}

	@Override
	public void read() throws GException {
		generic();
	}

	@Override
	public void write() throws GException {
		generic();
	}

	public String getName () {
		return name.getValue();
	}

}
