package GStandardApplication.calc;

/**
 * Class defining a vehicle.
 * @author goesterjf
 *
 */
public class Vehicle {
    
    /** Dry mass of the vehicle (kg)  */
    private final double dryMass;
    /** Ergols mass available (kg) */
    private final double ergolMass;
    /** Reference area (m2) */
    private final double sref;


    /**
     * Constructor
     * @param dryMass     Dry mass of the vehicle (kg)
     * @param ergolMass   Ergols mass available (kg)
     * @param sref        Reference area (m2)
     */
    public Vehicle (final double dryMass, final double ergolMass, final double sref ) {
        
        this.dryMass = dryMass;
        this.ergolMass = ergolMass;
        this.sref = sref;

    }

    /**
     * Method returning the total mass (i.e. dry + ergols mass).
     * @return total mass (kg)
     */
    public double getTotalMass (){
        return dryMass + ergolMass;
    }
    
    /**
     * Method returning the available ergols mass.
     * @return ergols mass (kg)
     */
    public double getErgolMass (){
        return ergolMass;
    }
    
    /**
     * Method returning the dry mass of the vehicle.
     * @return dry mass (kg)
     */
    public double getDryMass (){
        return dryMass;
    }
    
    /**
     * Method returning the reference area.
     * @return reference area (m2)
     */
    public double getSref (){
        return sref;
    }

}
