package GCondensedStatus;
import java.io.UnsupportedEncodingException;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GConsole;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GTabbedPane;
import fr.cnes.genius.main.GCondensedStatus;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;

/**
 * Testing condensed status
 * We have a widgetA in a pane and a widgetB in another one (so in different structures).
 * The goal of the test is to have a global status of the complete set of data.
 * @author goesterjf
 *
 */
public class TestForCondensedStatus extends GPanel implements GListener, GReadWrite {
	
	private GTabbedPane tabPane;
	private final TestForCondensedStatusWidget widgetA;
	private final TestForCondensedStatusWidget widgetB;
	private final GConsole console;
	
	public TestForCondensedStatus() throws GException {
		tabPane = new GTabbedPane("data");
		widgetA = new TestForCondensedStatusWidget("A");
		widgetB = new TestForCondensedStatusWidget("B");
		tabPane.addTab("Tab A", widgetA);
		tabPane.addTab("Tab B", widgetB);
		console = new GConsole();
		try {
			console.redirectSystemStreams(true, true);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
	}

	public void generic() throws GException {
		put(tabPane);
		put(console);
	}

	public void display() throws GException {
		generic();
	}

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

	@Override
	public void before(GEvent arg0) throws GException { }

	@Override
	public void after(GEvent arg0) throws GException {
		
		if ( arg0.contains(tabPane) ) {
			// Global status
			GCondensedStatus status = new GCondensedStatus(tabPane);
			System.out.println("Global status: "+status.getStatus());
			// Loop on errror messages
			for (int i = 0; i < status.getErrorComponentList().size(); i++) {
				final String root = status.getErrorComponentList().get(i).getGParent().getNameInConfigFile();
				final String name = status.getErrorComponentList().get(i).getNameInConfigFile();
				System.out.println("Error on "+root+"."+name);	
				System.out.println("Error on "+status.getErrorComponentList().get(i).getPathInConfigFile());
				System.out.println();
			}
			// Loop on warning messages
			for (int i = 0; i < status.getWarningComponentList().size(); i++) {
				final String root = status.getWarningComponentList().get(i).getGParent().getNameInConfigFile();
				final String name = status.getWarningComponentList().get(i).getNameInConfigFile();
				System.out.println("Warning on "+root+"."+name);				
                System.out.println("Error on "+status.getWarningComponentList().get(i).getPathInConfigFile());
			}
			GFileManipulation.writeConfig("TestForCondensesStatus.xml", "data", tabPane, false);
		}
		
	}

	/**
	 * @param args
	 * @throws GException 
	 */
	public static void main(String[] args) throws GException {
		TestForCondensedStatus pan = new TestForCondensedStatus();
		GFrame frame = new GFrame("TestForCondensedStatus", pan);	
		frame.display();
	}

}
