package GComponentList;

import java.awt.Dimension;
import java.util.ArrayList;

import fr.cnes.genius.exception.GComponentListException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.highLevel.GComponentList;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GImage;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GComponent;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;

/**
 * Test for class GComponentList
 * @author goesterjf
 *
 */
public class TestForGComponentList extends GPanel implements GReadWrite, GListener {
	
	private GCheckBox cb;
	private GComponentList test;
	
	public TestForGComponentList ( GComponentList test ) {
		
		this.test = test;
		cb = new GCheckBox("Editable");
		cb.setSelected(true);
		
	}
	
	@Override
	public void display() throws GException {
		//put(cb);
		generic();
	}
	
	@Override
	public void read() throws GException {
		generic();
		setEditable();
	}

	@Override
	public void write() throws GException {
		generic();
	}

	@Override
	public void generic() throws GException {
		put(test);
	}

	@Override
	public void before(GEvent arg0) throws GException {
	}

	@Override
	public void after(GEvent arg0) throws GException {
		if ( arg0.contains(cb) ) {
			setEditable();
		}
	}
	
	private void setEditable () {
		test.setEditable(cb.isSelected());
		for (int i = 0; i < test.getList().size(); i++) {
			((TestForGComponentListWidget)test.getList().get(i)).setEnabled(cb.isSelected());
		}
	}

	/**
	 * @param args
	 * @throws GFileManipulatorException 
	 */
	public static void main(String[] args) throws GFileManipulatorException {

		GComponentList test = null;
		
		ArrayList<GComponent> list = new ArrayList<GComponent>();
		list.add(new TestForGComponentListWidget("try", 99, 99., new GImage("/images/Sphere.png")));
		list.add(new TestForGComponentListWidget());
		
		
		test = new GComponentList("Test", TestForGComponentListWidget.class, false);
		test.setMinMaxElementNumber(0, 3);

		//test = new GComponentList("Test", TestForGComponentListWidget.class, false);
		try {
			test.setList(list);
		} catch (GComponentListException err) {
			err.printStackTrace();
		}
		test.setLabels("Amount of widgets", "widget number", "widget");
		
		GFrame frame = new GFrame("Test GComponentList", new TestForGComponentList(test));
		frame.setPreferredSize(new Dimension(800, 750));
		frame.display();
		
	}

}
