package Ex6.ihm;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.UnsupportedEncodingException;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GComponentList;
import fr.cnes.genius.highLevel.GConsole;
import fr.cnes.genius.highLevel.GMenu;
import fr.cnes.genius.highLevel.GMenuBar;
import fr.cnes.genius.highLevel.GMenuItem;
import fr.cnes.genius.lowLevel.GBufferedTextArea;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GIcon;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.threads.GCommandLauncher.GExecButton;
import fr.cnes.genius.threads.GCommandLauncher.GExecMenuItem;
import fr.cnes.genius.threads.GCommandLauncher.ProcessStatus;
import fr.cnes.genius.threads.GJavaCommandLauncher;

/**
 * Exercise #6 + clear + menu bar + GComponentList use
 * @author goesterjf
 *
 */
public class GEx63Panel extends GPanel implements GListener, GReadWrite {
	
	private GMenuBar menuBar;
	private GMenu menuFile;
	private GMenuItem itemLoad;
	private GMenuItem itemSave;
	private GExecMenuItem itemExec;
	private GMenuItem itemQuit;

	private GButton butLoad;
	private GButton butSave;
	private GButton butQuit;

	private GComponentList sceList;
	
	private GConsole console;
	
	private GJavaCommandLauncher cmd;
	private GExecButton butExec;
	
	/**
	 * Constructor.
	 * @throws UnsupportedEncodingException
	 */
	public GEx63Panel() throws UnsupportedEncodingException {
		
		console = new GConsole("Console", new GBufferedTextArea(500, 20, new File("log.txt")));
		console.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(),
				GConstraint.spanx(99), GConstraint.growx(), GConstraint.pushx(), GConstraint.height(100)), 5);
		
		console.redirectSystemStreams(true, false);
		console.getJTextArea().setFont(new Font("Courier", Font.PLAIN, 12));

		String path = System.getProperty("java.class.path");
		cmd = new GJavaCommandLauncher(new String[] {"Ex6.ihm.Batch63", "data63Tmp.xml"}, path, "Launch computation", "Stop computation", console);
		cmd.setButtonIcons(new GIcon(GIcon.Type.START, 12), new GIcon(GIcon.Type.STOP, 12));
		butExec= cmd.getGExecButton();
		butExec.setConstraint(null);
		
		itemLoad = new GMenuItem("Load");
		itemSave = new GMenuItem("Save");
		itemExec = cmd.getGExecMenuItem();
		itemQuit = new GMenuItem("Quit");
		
		menuFile = new GMenu("File");
		menuFile.add(itemLoad);
		menuFile.add(itemSave);
		menuFile.add(itemExec);
		menuFile.add(itemQuit);

		menuBar = new GMenuBar(this);
		menuBar.add(menuFile);
		
		butLoad = new GButton("Load");
		butLoad.setConstraint(new GConstraint(GConstraint.split(3)));
		butLoad.setIcon(new GIcon(GIcon.Type.OPEN, 12));
		butSave = new GButton("Save");
		butSave.setIcon(new GIcon(GIcon.Type.SAVE, 12));
		butSave.setConstraint(null);
		butQuit = new GButton("");
		butQuit = new GButton(new GIcon(GIcon.Type.EXIT, 36));
		butQuit.setConstraint(new GConstraint(GConstraint.skip(1), GConstraint.alignx(XAlign.Right), GConstraint.growx()));

		sceList = new GComponentList("scenario", GManeuver.class, false);
		sceList.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.spanx(99), GConstraint.growx(), GConstraint.pushx()));
		sceList.setVerticalScroll(ScrollBarVisibility.AS_NEEDED);
		
	}

	/**
	 * Before method override.
	 */
	public void before(GEvent e) throws GFileManipulatorException {
		
		if ( e.contains(butExec, itemExec) ) {
			if ( (! cmd.isRunning()) ) {
				if ( sceList.getList().size() > 0 ) {
					System.out.println("Writing data ...");
					GFileManipulation.writeConfig("data63Tmp.xml", "Data", sceList, false);
					System.out.println("Computation started ...");
				}
				else {
					System.out.println("Computation cancelled ...");
					cmd.setInhibited(true);
				}
			}
		}
		
	}

	/**
	 * After method override.
	 */
	public void after(GEvent e) throws GFileManipulatorException {
		
		if ( e.contains(butQuit) || e.contains(itemQuit) )	{ System.exit(0); }
				
		if ( e.contains(butLoad) || e.contains(itemLoad))	{ GFileManipulation.readConfig("data63.xml", "Data", sceList, false); }
		
		if ( e.contains(butSave) || e.contains(itemSave)) { GFileManipulation.writeConfig("data63.xml", "Data", sceList, true); }
		
		if ( e.getFinalSource() == cmd )	{
			// Application has been launched
			if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_NORMALY ) {
				System.out.println("Computation nominally stopped ...");
			}
			else if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_BY_USER ) {
				System.out.println("Computation stopped by user ...");
			}
		}
		
	}

	/**
	 * Generic method override.
	 */
	public void generic() throws GException {
		put(cmd);
		put(butLoad);
		put(butSave);
		put(butExec);
		put(butQuit);
		put(console);		
		put(sceList);		
	}

	/**
	 * Display method : only use generic one.
	 */
	public void display() throws GException { generic(); }

	/**
	 * Read method : only use generic one.
	 */
	public void read() throws GException { generic(); }

	/**
	 * Write method : only use generic one.
	 */
	public void write() throws GException { generic(); }
	
	/**
	 * Method to get the menu bar
	 * @return	menu bar
	 */
	public GMenuBar getMenuBar() {
		return menuBar;
	}
	
	/**
	 * @param args	no args ...
	 * @throws GIntervalException
	 */
	public static void main(String[] args) throws UnsupportedEncodingException {
		GEx63Panel pan = new GEx63Panel();
		GFrame frame = new GFrame("GEx6", pan, pan.getMenuBar());
		frame.setMinimumSize(new Dimension(600, 600));
		frame.display();
	}

}
