package Ex5.ihm;

import java.awt.Dimension;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;

/**
 * Exercise #5
 * @author goesterjf
 *
 */
public class GEx5Panel extends GPanel implements GListener {
	
	private GButton butLoad;
	private GButton butSave;
	private GButton but3;
	private GButton butQuit;

	private GScenario sceIhm;
	
	/**
	 * Constructor.
	 */
	public GEx5Panel() {
		
		butLoad = new GButton("Load");
		butLoad.setConstraint(new GConstraint(GConstraint.split(3)));
		butSave = new GButton("Save");
		butSave.setConstraint(null);
		but3 = new GButton("Button 3");
		but3.setConstraint(null);
		butQuit = new GButton("Quit");
		butQuit.setConstraint(new GConstraint(GConstraint.skip(1), GConstraint.alignx(XAlign.Right), GConstraint.growx()));

		sceIhm = new GScenario();
		sceIhm.setConstraint(new GConstraint(GConstraint.newline(true, 20), GConstraint.spanx(99), GConstraint.grow(), GConstraint.push()));
		
	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }

	/**
	 * Display method override.
	 */
	public void display() throws GException {
		put(butLoad);
		put(butSave);
		put(but3);
		put(butQuit);
		put(sceIhm);		
	}

	/**
	 * Before method : nothing to do.
	 */
	public void before(GEvent e) { }

	/**
	 * After method override.
	 */
	public void after(GEvent e) throws GFileManipulatorException {
		if ( e.contains(butLoad) )	{ GFileManipulation.readConfig("data5.xml", "Data", sceIhm, false); }
		if ( e.contains(butSave) ) { GFileManipulation.writeConfig("data5.xml", "Data", sceIhm, true); }
		if ( e.contains(butQuit) )	{ System.exit(0); }
	}

	/**
	 * Main method
	 * @param args	no args ...
	 */
	public static void main(String[] args) {

		GEx5Panel pan = new GEx5Panel();
		
		GFrame frame = new GFrame("GEx5", pan);
		frame.setMinimumSize(new Dimension(600, 500));
		
		frame.display();

	}

}
